/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolFilterSlot;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperFilterContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class ToolSwapperUpgradeContainer
extends UpgradeContainerBase<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeContainer> {
    private static final String DATA_SHOULD_SWAP_WEAPON = "shouldSwapWeapon";
    private static final String DATA_TOOL_SWAP_MODE = "toolSwapMode";
    private final FilterLogicContainerBase<ToolSwapperFilterLogic, ToolFilterSlot> filterLogicContainer = new ToolSwapperFilterContainer(this, upgradeWrapper::getFilterLogic, this.slots::add);

    public ToolSwapperUpgradeContainer(PlayerEntity player, int upgradeContainerId, ToolSwapperUpgradeWrapper upgradeWrapper, UpgradeContainerType<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_SHOULD_SWAP_WEAPON)) {
            this.setSwapWeapon(data.func_74767_n(DATA_SHOULD_SWAP_WEAPON));
        } else if (data.func_74764_b(DATA_TOOL_SWAP_MODE)) {
            this.setToolSwapMode(ToolSwapMode.fromName(data.func_74779_i(DATA_TOOL_SWAP_MODE)));
        } else {
            this.filterLogicContainer.handleMessage(data);
        }
    }

    public FilterLogicContainerBase<ToolSwapperFilterLogic, ToolFilterSlot> getFilterLogicContainer() {
        return this.filterLogicContainer;
    }

    public void setSwapWeapon(boolean shouldSwapWeapon) {
        ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).setSwapWeapon(shouldSwapWeapon);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundNBT(), DATA_SHOULD_SWAP_WEAPON, shouldSwapWeapon));
    }

    public boolean shouldSwapWeapon() {
        return ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).shouldSwapWeapon();
    }

    public void setToolSwapMode(ToolSwapMode toolSwapMode) {
        ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).setToolSwapMode(toolSwapMode);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_TOOL_SWAP_MODE, toolSwapMode));
    }

    public ToolSwapMode getToolSwapMode() {
        return ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).getToolSwapMode();
    }
}

